'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database


Public Declare Function ChooseFont Lib "comdlg32.dll" _
  Alias "ChooseFontA" ( _
  lpcf As CHOOSEFONT_TYPE) As Long


Public Type LOGFONT
  lfHeight As Long
  lfWidth As Long
  lfEscapement As Long
  lfOrientation As Long
  lfWeight As Long
  lfItalic As Byte
  lfUnderline As Byte
  lfStrikeOut As Byte
  lfCharSet As Byte
  lfOutPrecision As Byte
  lfClipPrecision As Byte
  lfQuality As Byte
  lfPitchAndFamily As Byte
  lfFaceName As String * 32
End Type
 
Public Type CHOOSEFONT_TYPE
  lStructSize As Long
  hwndOwner As Long
  hDC As Long
  lpLogFont As Long
  iPointSize As Long
  Flags As Long
  rgbColors As Long
  lCustData As Long
  lpfnHook As Long
  lpTemplateName As String
  hInstance As Long
  lpszStyle As String
  nFontType As Integer
  MISSING_ALIGNMENT As Integer
  nSizeMin As Long
  nSizeMax As Long
End Type
 
' Zeigt nur Windows- oder Unicode-Fonts
Public Const CF_ANSIONLY = &H400
' Zeigt einen "bernehmen" Button an
Public Const CF_APPLY = &H200
' Listet Drucker- und Bildschirm-Fonts
Public Const CF_BOTH = &H3
' Erlaubt Font-Besonderheiten wie
' Unterstreichen, Farbe und Durchgestrichen
Public Const CF_EFFECTS = &H100
' Aktiviert die Callback-Funktion
Public Const CF_ENABLEHOOK = &H8
' Der Dialog benutzt Template's die von
' TemplateNames festgelegt sind
Public Const CF_ENABLETEMPLATE = &H10
' Verwendet den durch hInstance festgelegten Dialog
Public Const CF_ENABLETEMPLATEHANDLE = &H20
' Listet nur Fixed-Pitch Fonts
Public Const CF_FIXEDPITCHONLY = &H4000
' Verweigert die Eingabe nicht aufgefhrter Fonts
Public Const CF_FORCEFONTEXIST = &H10000
' Setzt die Startwerte, welche ber die
' LOGFONT-Struktur angegeben wurden
Public Const CF_INITTOLOGFONTSTRUCT = &H40
' Erlaubt nur Schriftgren im Bereich "nSizeMin" und "nSizeMax"
Public Const CF_LIMITSIZE = &H2000
' Zeigt keine OEM Fonts
Public Const CF_NOOEMFONTS = &H800
' Kein Standard Facenamen selektieren
Public Const CF_NOFACESEL = &H80000
' Kein Standard Script selektieren
Public Const CF_NOSCRIPTSEL = &H800000
' keine Standardgre setzen
Public Const CF_NOSIZESEL = &H200000
' Kein Beispiel (Vorschau) anzeigen
Public Const CF_NOSIMULATIONS = &H1000
' kein Standard-Stil setzen
Public Const CF_NOSTYLESEL = &H100000
' keine Vector-Fonts anzeigen
Public Const CF_NOVECTORFONTS = &H800
' keine vertikal ausgerichtete Fonts anzeigen
Public Const CF_NOVERTFONTS = &H1000000
' Listet Drucker-Fonts
Public Const CF_PRINTERFONTS = &H2
' Listet nur skalierbare Fonts
Public Const CF_SCALABLEONLY = &H20000
' Listet Bildschirm-Fonts
Public Const CF_SCREENFONTS = &H1
' Listet nur Windows- oder Unicode-Fonts
Public Const CF_SCRIPTSONLY = &H400
' Listet nur Script-Fonts
Public Const CF_SELECTSCRIPT = &H400000
' Zeigt den Hilfe-Button an
Public Const CF_SHOWHELP = &H4
' Listet nur TrueType-Schriftarten
Public Const CF_TTONLY = &H40000
' Verwendet die in "lpStyle" angegebenen Werte
Public Const CF_USESTYLE = &H80
' Listet nur Fonts, die Drucker- und Bildschirm-Fonts gleichzeitig sind
' (muss benutzt werden mit CF_BOTH und CF_SCALABLEONLY)
Public Const CF_WYSIWYG = &H8000

' nFontType Konstanten
' ====================
Public Const BOLD_FONTTYPE = &H100          ' fett
Public Const ITALIC_FONTTYPE = &H200        ' kursiv
Public Const PRINTER_FONTTYPE = &H4000      ' Drucker-Fonts
Public Const REGULAR_FONTTYPE = &H400       ' regulre Fonts
Public Const SCREEN_FONTTYPE = &H2000       ' Bildschirm-Fonts
' Fonts, die in der Dialogbox simuliert werden knnen
Public Const SIMULATED_FONTTYPE = &H8000

' lfWeight Konstanten
' ===================
Public Const FW_DONTCARE = 0                ' Standard
Public Const FW_THIN = 100                  ' super dnn
Public Const FW_EXTRALIGHT = 200            ' extra dnn
Public Const FW_LIGHT = 300                 ' dnn
Public Const FW_NORMAL = 400                ' normal
Public Const FW_MEDIUM = 500                ' mittel
Public Const FW_SEMIBOLD = 600              ' etwas dicker
Public Const FW_BOLD = 700                  ' fett
Public Const FW_EXTRABOLD = 800             ' extra fett
Public Const FW_HEAVY = 900                 ' super fett
 
' lfCharSet Konstanten
' ====================
Public Const ANSI_CHARSET = 0               ' Ansi Zeichensatz
Public Const ARABIC_CHARSET = 178           ' Arabisch (NT/2000)
Public Const BALTIC_CHARSET = 186           ' Baltisch (Win 9x)
Public Const CHINESEBIG5_CHARSET = 136      ' Chinesisch
Public Const DEFAULT_CHARSET = 1            ' Standard
Public Const EASTEUROPE_CHARSET = 238       ' Osteuropisch (Win 9x)
Public Const GB2312_CHARSET = 134           ' Englisch
Public Const GREEK_CHARSET = 161            ' Griechisch (Win 9x)
Public Const HANGEUL_CHARSET = 129          ' Handgeul
Public Const HEBREW_CHARSET = 177           ' Hebrisch (NT/2000)
Public Const JOHAB_CHARSET = 130            ' Johab (Win 9x)
Public Const MAC_CHARSET = 77               ' Mac (Win 9x)
Public Const OEM_CHARSET = 255              ' OEM
Public Const RUSSIAN_CHARSET = 204          ' Russisch (Win 9x)
Public Const SHIFTJIS_CHARSET = 128         ' ShiftJis
Public Const SYMBOL_CHARSET = 2             ' Symbolisch
Public Const THAI_CHARSET = 222             ' Thailndisch (NT/2000)
Public Const TURKISH_CHARSET = 162          ' Trkisch (Win 9x)
 
' lfOutPrecision Konstanten
' =========================
' Verwendet die Standard-Font
Public Const OUT_DEFAULT_PRECIS = 0
' Verwendet eine Device-Font wenn mehrere
' Dateien mit dem selben Namen existieren
Public Const OUT_DEVICE_PRECIS = 5
' (NT/2000) Verwendet eine TrueType Schriftart
' oder Outline-Based Fonts.
Public Const OUT_OUTLINE_PRECIS = 8
' Verwendet ein Raster-Font, wenn mehrere
' Dateien mit dem selben Namen existieren
Public Const OUT_RASTER_PRECIS = 6
' Raster-Font fr die Enumeration
Public Const OUT_STRING_PRECIS = 1
' (Win 9x) Vector-Font fr die Enumeration
' (NT/2000) TrueType, Outline-Based oder VectorFont fr die Enumeration
Public Const OUT_STROKE_PRECIS = 3
' Verwendet eine TrueType-Schriftart
Public Const OUT_TT_ONLY_PRECIS = 7
' Verwendet eine TrueType-Font, wenn mehrere
' Dateien mit dem selben Namen existieren
Public Const OUT_TT_PRECIS = 4
 
' lfClipPrecision Konstanten
' ==========================
' Standard
Public Const CLIP_DEFAULT_PRECIS = 0
' wird benutzt fr eingebettete schreibgeschtzte Fonts
Public Const CLIP_EMBEDDED = 128
' die Richtung von irgendwelchen Rotationen wird vom
' Koordinatensystem festgelegt (gegen den Uhrzeigersinn)
Public Const CLIP_LH_ANGLES = 16
' Raster-Vector oder TrueType-Fonts fr die Enumeration
Public Const CLIP_STROKE_PRECIS = 2
 
' lfQuality Konstanten
' ====================
' (Win 9x, NT 4.0, 2000) Schriftart wird wenn mglich
' immer mit Anitialisierung gezeichnet
Public Const ANTIALIASED_QUALITY = 4
' Standard Qualitt
Public Const DEFAULT_QUALITY = 0
' entspricht "Schnelldruck" bei Druckausgaben
Public Const DRAFT_QUALITY = 1
' (Win 9x, NT 4.0, 2000) Schriftart wird nicht mit
' Anitialisierung gezeichnet
Public Const NONANTIALIASED_QUALITY = 3
' entspricht "Schndruck" bei Druckausgaben
Public Const PROOF_QUALITY = 2
 
' lfPitchAndFamily Konstanten
' ===========================
Public Const DEFAULT_PITCH = 0          ' Standard
Public Const FIXED_PITCH = 1            ' Fest
Public Const VARIABLE_PITCH = 2         ' Variabel
Public Const FF_DECORATIVE = 80         ' Dekoriert
Public Const FF_DONTCARE = 0            ' Egal
Public Const FF_MODERN = 48             ' Modern
Public Const FF_ROMAN = 16              ' Roman
Public Const FF_SCRIPT = 64             ' Script
Public Const FF_SWISS = 32              ' Swiss

